program PrzypisanieDowolnegoKoduDoMetodyAnonimowej;

{$APPTYPE CONSOLE}

uses
  System.SysUtils;

type
  TReferencjaDoMetody = procedure(aTekst: string) of object;
  TMetodaAnonimowa = reference to procedure(aTekst: string);
  TReferencjaDoProcedury = procedure(aTekst: string);

var
  MA: TMetodaAnonimowa;
  RP: TReferencjaDoProcedury;

procedure ReferencjaDoProcedury(aTekst: string);
begin
  WriteLn('Jestem referencj do procedury: ' + aTekst);
end;

type
  TJakaKlasa = class
  private
    FZdarzenie: TMetodaAnonimowa;
  public
   procedure ReferencjaDoMetody(aTekst: string);
   procedure UstawReferencjDoMetody(aReferencjaDoMetodyAnonimowej:TMetodaAnonimowa);
   constructor Utwrz;
   procedure WywoajZdarzenie;
   property PoWystpieniuZdarzenia: TMetodaAnonimowa read FZdarzenie
                                                     write FZdarzenie;
  end;

var
  JakaKlasa: TJakaKlasa;

constructor TJakaKlasa.Utwrz;
begin
  inherited;
  FZdarzenie := ReferencjaDoMetody;
end;

procedure TJakaKlasa.WywoajZdarzenie;
begin
  if Assigned(FZdarzenie) then
    FZdarzenie('Wywoanie zdarzenia');
end;

procedure TJakaKlasa.ReferencjaDoMetody(aTekst: string);
begin
  WriteLn('Jestem referencj do metody: ' + aTekst);
end;

procedure TJakaKlasa.UstawReferencjDoMetody(aReferencjaDoMetodyAnonimowej:
                      TMetodaAnonimowa);
begin
  FZdarzenie := aReferencjaDoMetodyAnonimowej;
end;

begin
  RP := ReferencjaDoProcedury;

  MA := procedure(aTekst: string)
        begin
          WriteLn('Jestem metod anonimow: ' + aTekst);
        end;

  JakaKlasa := TJakaKlasa.Utwrz;
  try
    JakaKlasa.UstawReferencjDoMetody(MA);
    JakaKlasa.WywoajZdarzenie;
    JakaKlasa.UstawReferencjDoMetody(RP);
    JakaKlasa.WywoajZdarzenie;
    JakaKlasa.UstawReferencjDoMetody(JakaKlasa.ReferencjaDoMetody);
    JakaKlasa.WywoajZdarzenie;
  finally
    JakaKlasa.Free;
  end;
  ReadLn;
end.
